# Bildungsplan Mathematik BW - Strukturierte Daten

**Version:** 2016 / Fassung 29.02.2024  
**Gültig ab:** 01.08.2024  
**Schulart:** Gymnasium  
**Fach:** Mathematik  
**Bundesland:** Baden-Württemberg

---

## 📂 Dateien im Paket

### **00_META.jsonl**
Zentrale Meta-Daten für alle Klassenstufen:
- Framework (Kompetenzorientierung)
- Anforderungsbereiche (AFB I, II, III)
- 5 Leitideen
- 7 Prozessbezogene Kompetenzen
- 6 Didaktische Prinzipien
- 21 Operatoren mit AFB-Zuordnung

---

### **Nach Leitideen organisiert:**

#### **LI-ZVO_alle-stufen.jsonl** (46 Kompetenzen)
**Zahl – Variable – Operation**
- Umgang mit Zahlen, Termen, Variablen und Rechenoperationen
- Enthält: Klasse 9/10, 11/12 Leistungsfach, 11/12 Basisfach

#### **LI-MESS_alle-stufen.jsonl** (30 Kompetenzen)
**Messen**
- Bestimmen, Vergleichen und Berechnen von Größen
- Enthält: Klasse 9/10, 11/12 Leistungsfach, 11/12 Basisfach

#### **LI-RF_alle-stufen.jsonl** (33 Kompetenzen)
**Raum und Form**
- Geometrische Objekte, Beziehungen und Darstellungen
- Enthält: Klasse 9/10, 11/12 Leistungsfach, 11/12 Basisfach

#### **LI-FUNK_alle-stufen.jsonl** (68 Kompetenzen)
**Funktionaler Zusammenhang**
- Abhängigkeiten zwischen Größen und deren Darstellungen
- Enthält: Klasse 9/10, 11/12 Leistungsfach, 11/12 Basisfach

#### **LI-DZ_alle-stufen.jsonl** (28 Kompetenzen)
**Daten und Zufall**
- Statistik, Wahrscheinlichkeiten und Zufallsexperimente
- Enthält: Klasse 9/10, 11/12 Leistungsfach, 11/12 Basisfach

---

### **Nach Klassenstufen organisiert:**

#### **gym_mathe_9-10_bereinigt.jsonl**
Alle Kompetenzen Klasse 9/10 (mit Meta-Daten)

#### **gym_mathe_11-12-LF_bereinigt.jsonl**
Alle Kompetenzen Klasse 11/12 Leistungsfach (mit Meta-Daten)

#### **gym_mathe_11-12-BF_KORREKT.jsonl**
Alle Kompetenzen Klasse 11/12 Basisfach (mit Meta-Daten)
- **Wichtig:** Stochastik nur Normalverteilung (KEINE Hypothesentests!)

---

## 📊 Statistik

| Leitidee | Anzahl Kompetenzen |
|----------|-------------------|
| LI-ZVO   | 46                |
| LI-MESS  | 30                |
| LI-RF    | 33                |
| LI-FUNK  | 68                |
| LI-DZ    | 28                |
| **GESAMT** | **205** |

---

## 🎯 Verwendungszwecke

### **Für RAG-Systeme:**
- Leitideen-Dateien für thematisch fokussierte Retrieval
- Meta-Daten für Kontext-Anreicherung
- Konsistente JSON-Struktur für einfaches Parsen

### **Für Lehrer-Fortbildungen:**
- Spiralcurriculum sichtbar machen (Leitideen-Dateien)
- Operatoren mit AFB-Zuordnung (00_META.jsonl)
- Prozessbezogene Kompetenzen erklären

### **Für Aufgabenentwicklung:**
- Operatoren für korrekte Aufgabenstellung
- AFB-Zuordnung für Niveaustufung
- Kompetenzen als Basis für Lernziele

---

## 🔧 Datenstruktur

Jede Kompetenz hat folgende Felder:
```json
{
  "type": "kompetenz",
  "id": "eindeutige-id",
  "grade_band": "9/10" | "11/12 (Leistungsfach)" | "11/12 (Basisfach)",
  "section": "3.X.X",
  "leitidee": "Name der Leitidee",
  "nr": 1,
  "text": "Kompetenzformulierung",
  "xref": [...]  // optional: Querverweise
}
```

---

## ⚠️ Wichtige Hinweise

### **Stochastik Basisfach vs. Leistungsfach:**
- **Basisfach:** Nur Normalverteilung (3 Kompetenzen)
- **Leistungsfach:** Normalverteilung + Hypothesentests (10 Kompetenzen)
- **Beide:** Mittelstufe-Inhalte (Vierfeldertafel, Binomialverteilung etc.) bleiben prüfbar!

### **Fehlende Formeln:**
Einige Kompetenzen enthalten `[FORMEL_FEHLT: ...]` - diese müssen manuell aus dem PDF ergänzt werden.

### **Klasse 5/6 und 7/8:**
Noch nicht im Paket enthalten - können später ergänzt werden.

---

## 📝 Lizenz & Quelle

**Quelle:** Bildungsplan 2016 Gymnasium Mathematik Baden-Württemberg  
**Herausgeber:** Ministerium für Kultus, Jugend und Sport Baden-Württemberg  
**Bearbeitung:** Strukturierung und Aufbereitung für digitale Nutzung

---

**Erstellt am:** 21.12.2024  
**Format:** JSON Lines (.jsonl)  
**Encoding:** UTF-8
